
<?php $__env->startSection('admin_content'); ?>
    <h1 class="h3 mb-3 text-gray-800"><?php echo e(ADD_LISTING); ?></h1>

    <form action="<?php echo e(route('admin_listing_store')); ?>" method="post" enctype="multipart/form-data">
        <?php echo csrf_field(); ?>

        <div class="card shadow mb-4 t-left">
            <div class="card-header py-3">
                <h6 class="m-0 mt-2 font-weight-bold text-primary"></h6>
                <div class="float-right d-inline">
                    <a href="<?php echo e(route('admin_listing_view')); ?>" class="btn btn-primary btn-sm"><i class="fa fa-plus"></i> <?php echo e(VIEW_ALL); ?></a>
                </div>
            </div>
            <div class="card-body">
                <div class="row">
                    <div class="col-3">
                        <div class="nav flex-column nav-pills" id="v-pills-tab" role="tablist" aria-orientation="vertical">
                            <a class="nav-link active" id="p1_tab" data-toggle="pill" href="#p1" role="tab" aria-controls="p1" aria-selected="true"><?php echo e(MAIN_SECTION); ?></a>
                            <a class="nav-link" id="p10_tab" data-toggle="pill" href="#p10" role="tab" aria-controls="p10" aria-selected="false"><?php echo e(FEATURES); ?></a>
                            <a class="nav-link" id="p2_tab" data-toggle="pill" href="#p2" role="tab" aria-controls="p2" aria-selected="false"><?php echo e(OPENING_HOUR); ?></a>
                            <a class="nav-link" id="p3_tab" data-toggle="pill" href="#p3" role="tab" aria-controls="p3" aria-selected="false"><?php echo e(SOCIAL_MEDIA); ?></a>
                            <a class="nav-link" id="p4_tab" data-toggle="pill" href="#p4" role="tab" aria-controls="p4" aria-selected="false"><?php echo e(AMENITY); ?></a>
                            <a class="nav-link" id="p5_tab" data-toggle="pill" href="#p5" role="tab" aria-controls="p5" aria-selected="false"><?php echo e(PHOTO_GALLERY); ?></a>
                            <a class="nav-link" id="p6_tab" data-toggle="pill" href="#p6" role="tab" aria-controls="p6" aria-selected="false"><?php echo e(VIDEO_GALLERY); ?></a>
                            <a class="nav-link" id="p7_tab" data-toggle="pill" href="#p7" role="tab" aria-controls="p7" aria-selected="false"><?php echo e(ADDITIONAL_FEATURES); ?></a>
                            <a class="nav-link" id="p8_tab" data-toggle="pill" href="#p8" role="tab" aria-controls="p8" aria-selected="false"><?php echo e(SEO); ?></a>
                            <a class="nav-link" id="p9_tab" data-toggle="pill" href="#p9" role="tab" aria-controls="p9" aria-selected="false"><?php echo e(STATUS_AND_FEATURED); ?></a>
                        </div>
                    </div>
                    <div class="col-9">
                        <div class="tab-content" id="v-pills-tabContent">

                            <!-- Tab 1 -->
                            <div class="tab-pane fade show active" id="p1" role="tabpanel" aria-labelledby="p1_tab">
                                <div class="row">
                                    <div class="col-md-6">
                                        <div class="form-group">
                                            <label for=""><?php echo e(NAME); ?> *</label>
                                            <input type="text" name="listing_name" class="form-control" value="<?php echo e(old('listing_name')); ?>" autofocus>
                                        </div>
                                    </div>
                                    <div class="col-md-6">
                                        <div class="form-group">
                                            <label for=""><?php echo e(SLUG); ?></label>
                                            <input type="text" name="listing_slug" class="form-control" value="<?php echo e(old('listing_slug')); ?>">
                                        </div>
                                    </div>
                                </div>

                                <div class="form-group">
                                    <label for=""><?php echo e(DESCRIPTION); ?> *</label>
                                    <textarea name="listing_description" class="form-control editor" cols="30" rows="10"><?php echo e(old('listing_description')); ?></textarea>
                                </div>

                                <div class="row">
                                    <div class="col-md-6">
                                        <div class="form-group">
                                            <label for=""><?php echo e(LISTING_BRAND); ?></label>
                                            <select name="listing_brand_id" class="form-control select2">
                                                <?php $__currentLoopData = $listing_brand; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $row): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <option value="<?php echo e($row->id); ?>"><?php echo e($row->listing_brand_name); ?></option>
                                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                            </select>
                                        </div>
                                    </div>
                                    <div class="col-md-6">
                                        <div class="form-group">
                                            <label for=""><?php echo e(LISTING_LOCATION); ?></label>
                                            <select name="listing_location_id" class="form-control select2">
                                                <?php $__currentLoopData = $listing_location; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $row): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <option value="<?php echo e($row->id); ?>"><?php echo e($row->listing_location_name); ?></option>
                                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                            </select>
                                        </div>
                                    </div>
                                </div>
                                <div class="row">
                                    <div class="col-md-6">
                                        <div class="form-group">
                                            <label for=""><?php echo e(ADDRESS); ?></label>
                                            <textarea name="listing_address" class="form-control h_70" cols="30" rows="10"><?php echo e(old('listing_address')); ?></textarea>
                                        </div>
                                    </div>
                                    <div class="col-md-6">
                                        <div class="form-group">
                                            <label for=""><?php echo e(PHONE); ?></label>
                                            <textarea name="listing_phone" class="form-control h_70" cols="30" rows="10"><?php echo e(old('listing_phone')); ?></textarea>
                                        </div>
                                    </div>
                                    <div class="col-md-6">
                                        <div class="form-group">
                                            <label for=""><?php echo e(EMAIL); ?></label>
                                            <textarea name="listing_email" class="form-control h_70" cols="30" rows="10"><?php echo e(old('listing_email')); ?></textarea>
                                        </div>
                                    </div>
                                    <div class="col-md-6">
                                        <div class="form-group">
                                            <label for=""><?php echo e(MAP_IFRAME_CODE); ?></label>
                                            <textarea name="listing_map" class="form-control h_70" cols="30" rows="10"><?php echo e(old('listing_map')); ?></textarea>
                                        </div>
                                    </div>
                                </div>
                                <div class="form-group">
                                    <label for=""><?php echo e(WEBSITE); ?></label>
                                    <input type="text" name="listing_website" class="form-control" value="<?php echo e(old('listing_website')); ?>">
                                </div>

                                <div class="form-group">
                                    <label for=""><?php echo e(FEATURED_PHOTO); ?> *</label>
                                    <div>
                                        <input type="file" name="listing_featured_photo">
                                    </div>
                                </div>
                            </div>
                            <!-- // Tab 1 -->



                            <!-- Tab 10 -->
                            <div class="tab-pane fade" id="p10" role="tabpanel" aria-labelledby="p10_tab">

                                <h4 class="heading-in-tab"><?php echo e(FEATURES); ?></h4>
                                <div class="row">
                                    <div class="col-md-6">
                                        <div class="form-group">
                                            <label for=""><?php echo e(PRICE); ?> *</label>
                                            <input type="text" name="listing_price" class="form-control" value="<?php echo e(old('listing_price')); ?>">
                                        </div>
                                    </div>
                                    <div class="col-md-6">
                                        <div class="form-group">
                                            <label for=""><?php echo e(TYPE); ?></label>
                                            <select name="listing_type" class="form-control">
                                                <option value="New Car"><?php echo e(NEW_CAR); ?></option>
                                                <option value="Used Car"><?php echo e(USED_CAR); ?></option>
                                            </select>
                                        </div>
                                    </div>
                                    <div class="col-md-6">
                                        <div class="form-group">
                                            <label for=""><?php echo e(EXTERIOR_COLOR); ?></label>
                                            <input type="text" name="listing_exterior_color" class="form-control" value="<?php echo e(old('listing_exterior_color')); ?>">
                                        </div>
                                    </div>
                                    <div class="col-md-6">
                                        <div class="form-group">
                                            <label for=""><?php echo e(INTERIOR_COLOR); ?></label>
                                            <input type="text" name="listing_interior_color" class="form-control" value="<?php echo e(old('listing_interior_color')); ?>">
                                        </div>
                                    </div>
                                    <div class="col-md-6">
                                        <div class="form-group">
                                            <label for=""><?php echo e(CYLINDER); ?></label>
                                            <input type="text" name="listing_cylinder" class="form-control" value="<?php echo e(old('listing_cylinder')); ?>">
                                        </div>
                                    </div>
                                    <div class="col-md-6">
                                        <div class="form-group">
                                            <label for=""><?php echo e(FUEL_TYPE); ?></label>
                                            <input type="text" name="listing_fuel_type" class="form-control" value="<?php echo e(old('listing_fuel_type')); ?>">
                                        </div>
                                    </div>
                                    <div class="col-md-6">
                                        <div class="form-group">
                                            <label for=""><?php echo e(TRANSMISSION); ?></label>
                                            <input type="text" name="listing_transmission" class="form-control" value="<?php echo e(old('listing_transmission')); ?>">
                                        </div>
                                    </div>
                                    <div class="col-md-6">
                                        <div class="form-group">
                                            <label for=""><?php echo e(ENGINE_CAPACITY); ?></label>
                                            <input type="text" name="listing_engine_capacity" class="form-control" value="<?php echo e(old('listing_engine_capacity')); ?>">
                                        </div>
                                    </div>
                                    <div class="col-md-6">
                                        <div class="form-group">
                                            <label for=""><?php echo e(VIN); ?></label>
                                            <input type="text" name="listing_vin" class="form-control" value="<?php echo e(old('listing_vin')); ?>">
                                        </div>
                                    </div>
                                    <div class="col-md-6">
                                        <div class="form-group">
                                            <label for=""><?php echo e(BODY); ?></label>
                                            <input type="text" name="listing_body" class="form-control" value="<?php echo e(old('listing_body')); ?>">
                                        </div>
                                    </div>
                                    <div class="col-md-6">
                                        <div class="form-group">
                                            <label for=""><?php echo e(SEAT); ?></label>
                                            <input type="text" name="listing_seat" class="form-control" value="<?php echo e(old('listing_seat')); ?>">
                                        </div>
                                    </div>
                                    <div class="col-md-6">
                                        <div class="form-group">
                                            <label for=""><?php echo e(WHEEL); ?></label>
                                            <input type="text" name="listing_wheel" class="form-control" value="<?php echo e(old('listing_wheel')); ?>">
                                        </div>
                                    </div>
                                    <div class="col-md-6">
                                        <div class="form-group">
                                            <label for=""><?php echo e(DOOR); ?></label>
                                            <input type="text" name="listing_door" class="form-control" value="<?php echo e(old('listing_door')); ?>">
                                        </div>
                                    </div>
                                    <div class="col-md-6">
                                        <div class="form-group">
                                            <label for=""><?php echo e(MILEAGE); ?></label>
                                            <input type="text" name="listing_mileage" class="form-control" value="<?php echo e(old('listing_mileage')); ?>">
                                        </div>
                                    </div>
                                    <div class="col-md-6">
                                        <div class="form-group">
                                            <label for=""><?php echo e(MODEL_YEAR); ?></label>
                                            <input type="text" name="listing_model_year" class="form-control" value="<?php echo e(old('listing_model_year')); ?>">
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <!-- // Tab 10 -->



                            <!-- Tab 2 -->
                            <div class="tab-pane fade" id="p2" role="tabpanel" aria-labelledby="p2_tab">

                                <h4 class="heading-in-tab"><?php echo e(OPENING_HOUR); ?></h4>
                                <div class="row">
                                    <div class="col-md-6">
                                        <div class="form-group">
                                            <label for=""><?php echo e(MONDAY); ?></label>
                                            <input type="text" name="listing_oh_monday" class="form-control" value="<?php echo e(old('listing_oh_monday')); ?>">
                                        </div>
                                    </div>
                                    <div class="col-md-6">
                                        <div class="form-group">
                                            <label for=""><?php echo e(TUESDAY); ?></label>
                                            <input type="text" name="listing_oh_tuesday" class="form-control" value="<?php echo e(old('listing_oh_tuesday')); ?>">
                                        </div>
                                    </div>
                                    <div class="col-md-6">
                                        <div class="form-group">
                                            <label for=""><?php echo e(WEDNESDAY); ?></label>
                                            <input type="text" name="listing_oh_wednesday" class="form-control" value="<?php echo e(old('listing_oh_wednesday')); ?>">
                                        </div>
                                    </div>
                                    <div class="col-md-6">
                                        <div class="form-group">
                                            <label for=""><?php echo e(THURSDAY); ?></label>
                                            <input type="text" name="listing_oh_thursday" class="form-control" value="<?php echo e(old('listing_oh_thursday')); ?>">
                                        </div>
                                    </div>
                                    <div class="col-md-6">
                                        <div class="form-group">
                                            <label for=""><?php echo e(FRIDAY); ?></label>
                                            <input type="text" name="listing_oh_friday" class="form-control" value="<?php echo e(old('listing_oh_friday')); ?>">
                                        </div>
                                    </div>
                                    <div class="col-md-6">
                                        <div class="form-group">
                                            <label for=""><?php echo e(SATURDAY); ?></label>
                                            <input type="text" name="listing_oh_saturday" class="form-control" value="<?php echo e(old('listing_oh_saturday')); ?>">
                                        </div>
                                    </div>
                                    <div class="col-md-6">
                                        <div class="form-group">
                                            <label for=""><?php echo e(SUNDAY); ?></label>
                                            <input type="text" name="listing_oh_sunday" class="form-control" value="<?php echo e(old('listing_oh_sunday')); ?>">
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <!-- // Tab 2 -->



                            <!-- Tab 3 -->
                            <div class="tab-pane fade" id="p3" role="tabpanel" aria-labelledby="p3_tab">

                                <h4 class="heading-in-tab"><?php echo e(SOCIAL_ICONS); ?></h4>
                                <div class="social_item">
                                    <div class="row">
                                        <div class="col-md-5">
                                            <div class="form-group">
                                                <select name="social_icon[]" class="form-control">
                                                    <option value="Facebook"><?php echo e(FACEBOOK); ?></option>
                                                    <option value="Twitter"><?php echo e(TWITTER); ?></option>
                                                    <option value="LinkedIn"><?php echo e(LINKEDIN); ?></option>
                                                    <option value="YouTube"><?php echo e(YOUTUBE); ?></option>
                                                    <option value="Pinterest"><?php echo e(PINTEREST); ?></option>
                                                    <option value="GooglePlus"><?php echo e(GOOGLE_PLUS); ?></option>
                                                    <option value="Instagram"><?php echo e(INSTAGRAM); ?></option>
                                                </select>
                                            </div>
                                        </div>
                                        <div class="col-md-6">
                                            <div class="form-group">
                                                <input type="text" name="social_url[]" class="form-control" placeholder="URL">
                                            </div>
                                        </div>
                                        <div class="col-md-1">
                                            <div class="btn btn-success add_social_more"><i class="fas fa-plus"></i></div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <!-- // Tab 3 -->


                            <!-- Tab 4 -->
                            <div class="tab-pane fade" id="p4" role="tabpanel" aria-labelledby="p4_tab">

                                <h4 class="heading-in-tab"><?php echo e(AMENITY); ?></h4>
                                <div class="row">
                                    <?php $i=0; ?>
                                    <?php $__currentLoopData = $amenity; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $row): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <?php $i++; ?>
                                    <div class="col-md-4">
                                        <div class="form-check mb_10">
                                            <input class="form-check-input" name="amenity[]" type="checkbox" value="<?php echo e($row->id); ?>" id="amenities<?php echo e($i); ?>">
                                            <label class="form-check-label" for="amenities<?php echo e($i); ?>">
                                                <?php echo e($row->amenity_name); ?>

                                            </label>
                                        </div>
                                    </div>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </div>
                            </div>
                            <!-- // Tab 4 -->



                            <!-- Tab 5 -->
                            <div class="tab-pane fade" id="p5" role="tabpanel" aria-labelledby="p5_tab">

                                <h4 class="heading-in-tab"><?php echo e(PHOTOS); ?></h4>
                                <div class="photo_item">
                                    <div class="row">
                                        <div class="col-md-5">
                                            <div class="form-group">
                                                <div>
                                                    <input type="file" name="photo_list[]">
                                                </div>
                                            </div>
                                        </div>
                                        <div class="col-md-1">
                                            <div class="btn btn-success add_photo_more"><i class="fas fa-plus"></i></div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <!-- // Tab 5 -->


                            <!-- Tab 6 -->
                            <div class="tab-pane fade" id="p6" role="tabpanel" aria-labelledby="p6_tab">
                                <h4 class="heading-in-tab"><?php echo e(VIDEOS); ?></h4>
                                <div class="video_item">
                                    <div class="row">
                                        <div class="col-md-5">
                                            <div class="form-group">
                                                <input type="text" name="youtube_video_id[]" class="form-control" placeholder="<?php echo e(YOUTUBE_VIDEO_ID); ?>">
                                            </div>
                                        </div>
                                        <div class="col-md-1">
                                            <div class="btn btn-success add_video_more"><i class="fas fa-plus"></i></div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <!-- // Tab 6 -->


                            <!-- Tab 7 -->
                            <div class="tab-pane fade" id="p7" role="tabpanel" aria-labelledby="p7_tab">
                                <h4 class="heading-in-tab"><?php echo e(ADDITIONAL_FEATURES); ?></h4>
                                <div class="additional_feature_item">
                                    <div class="row">
                                        <div class="col-md-5">
                                            <div class="form-group">
                                                <input type="text" name="additional_feature_name[]" class="form-control" placeholder="<?php echo e(NAME); ?>">
                                            </div>
                                        </div>
                                        <div class="col-md-6">
                                            <div class="form-group">
                                                <input type="text" name="additional_feature_value[]" class="form-control" placeholder="<?php echo e(VALUE); ?>">
                                            </div>
                                        </div>
                                        <div class="col-md-1">
                                            <div class="btn btn-success add_additional_feature_more"><i class="fas fa-plus"></i></div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <!-- // Tab 7 -->


                            <!-- Tab 8 -->
                            <div class="tab-pane fade" id="p8" role="tabpanel" aria-labelledby="p8_tab">
                                <div class="form-group">
                                    <label for=""><?php echo e(TITLE); ?></label>
                                    <input type="text" name="seo_title" class="form-control" value="<?php echo e(old('seo_title')); ?>">
                                </div>
                                <div class="form-group">
                                    <label for=""><?php echo e(META_DESCRIPTION); ?></label>
                                    <textarea name="seo_meta_description" class="form-control h_100" cols="30" rows="10"><?php echo e(old('seo_meta_description')); ?></textarea>
                                </div>
                            </div>
                            <!-- // Tab 8 -->


                            <!-- Tab 9 -->
                            <div class="tab-pane fade" id="p9" role="tabpanel" aria-labelledby="p9_tab">
                                <div class="row">
                                    <div class="col-md-4">
                                        <div class="form-group">
                                            <label for=""><?php echo e(STATUS); ?></label>
                                            <select name="listing_status" class="form-control">
                                                <option value="Active"><?php echo e(ACTIVE); ?></option>
                                                <option value="Pending"><?php echo e(PENDING); ?></option>
                                            </select>
                                        </div>
                                    </div>
                                </div>
                                <div class="row">
                                    <div class="col-md-4">
                                        <div class="form-group">
                                            <label for=""><?php echo e(QUESTION_IS_FEATURED); ?></label>
                                            <select name="is_featured" class="form-control">
                                                <option value="Yes"><?php echo e(YES); ?></option>
                                                <option value="No"><?php echo e(NO); ?></option>
                                            </select>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <!-- // Tab 9 -->

                        </div>
                    </div>
                </div>
            </div>
        </div>

        <button type="submit" class="btn btn-success btn-block mb_40"><?php echo e(SUBMIT); ?></button>
    </form>


<div class="d_n">
	<div id="add_social">
		<div class="delete_social">
			<div class="row">
                <div class="col-md-5">
                    <div class="form-group">
                        <select name="social_icon[]" class="form-control">
                            <option value="Facebook"><?php echo e(FACEBOOK); ?></option>
                            <option value="Twitter"><?php echo e(TWITTER); ?></option>
                            <option value="LinkedIn"><?php echo e(LINKEDIN); ?></option>
                            <option value="YouTube"><?php echo e(YOUTUBE); ?></option>
                            <option value="Pinterest"><?php echo e(PINTEREST); ?></option>
                            <option value="GooglePlus"><?php echo e(GOOGLE_PLUS); ?></option>
                            <option value="Instagram"><?php echo e(INSTAGRAM); ?></option>
                        </select>
                    </div>
                </div>
                <div class="col-md-6">
                    <div class="form-group">
                        <input type="text" name="social_url[]" class="form-control" placeholder="<?php echo e(URL); ?>">
                    </div>
                </div>
                <div class="col-md-1">
                    <div class="btn btn-danger remove_social_more"><i class="fas fa-minus"></i></div>
                </div>
			</div>
		</div>
	</div>
</div>


<div class="d_n">
	<div id="add_photo">
		<div class="delete_photo">
			<div class="row">
				<div class="col-md-5">
                    <div class="form-group">
                        <div>
                            <input type="file" name="photo_list[]">
                        </div>
                    </div>
				</div>
				<div class="col-md-1">
                    <div class="btn btn-danger remove_photo_more"><i class="fas fa-minus"></i></div>
                </div>
			</div>
		</div>
	</div>
</div>


<div class="d_n">
	<div id="add_video">
		<div class="delete_video">
			<div class="row">
				<div class="col-md-5">
                    <div class="form-group">
                        <input type="text" name="youtube_video_id[]" class="form-control" placeholder="<?php echo e(YOUTUBE_VIDEO_ID); ?>">
                    </div>
				</div>
				<div class="col-md-1">
                    <div class="btn btn-danger remove_video_more"><i class="fas fa-minus"></i></div>
                </div>
			</div>
		</div>
	</div>
</div>


<div class="d_n">
	<div id="add_additional_feature">
		<div class="delete_additional_feature">
			<div class="row">
				<div class="col-md-5">
                    <div class="form-group">
                        <input type="text" name="additional_feature_name[]" class="form-control" placeholder="<?php echo e(NAME); ?>">
                    </div>
				</div>
                <div class="col-md-6">
                    <div class="form-group">
                        <input type="text" name="additional_feature_value[]" class="form-control" placeholder="<?php echo e(VALUE); ?>">
                    </div>
				</div>
				<div class="col-md-1">
                    <div class="btn btn-danger remove_additional_feature_more"><i class="fas fa-minus"></i></div>
                </div>
			</div>
		</div>
	</div>
</div>

<?php $__env->stopSection(); ?>

<?php echo $__env->make('admin.app_admin', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/tbooking/globalegyptlimousine.com/resources/views/admin/listing_create.blade.php ENDPATH**/ ?>