
<?php $__env->startSection('admin_content'); ?>
    <h1 class="h3 mb-3 text-gray-800"><?php echo e(CUSTOMERS); ?></h1>

    <div class="card shadow mb-4">
        <div class="card-body">
            <div class="table-responsive">
                <table class="table table-bordered" id="dataTable" width="100%" cellspacing="0">
                    <thead>
                    <tr>
                        <th><?php echo e(SERIAL); ?></th>
                        <th><?php echo e(PHOTO); ?></th>
                        <th><?php echo e(NAME); ?></th>
                        <th><?php echo e(EMAIL); ?></th>
                        <th><?php echo e(STATUS); ?></th>
                        <th><?php echo e(ACTION); ?></th>
                    </tr>
                    </thead>
                    <tbody>
                    <?php $__currentLoopData = $customers; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $row): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <tr>
                            <td><?php echo e($loop->iteration); ?></td>
                            <td>
                                <?php if($row->photo == ''): ?>
                                    <img src="<?php echo e(asset('uploads/user_photos/default_photo.jpg')); ?>" class="w_100">
                                <?php else: ?>
                                    <img src="<?php echo e(asset('uploads/user_photos/'.$row->photo)); ?>" class="w_100">
                                <?php endif; ?>
                            </td>
                            <td><?php echo e($row->name); ?></td>
                            <td><?php echo e($row->email); ?></td>
                            <td>
                                <?php if($row->status == 'Active'): ?>
                                <a href="" onclick="customerStatus(<?php echo e($row->id); ?>)"><input type="checkbox" checked data-toggle="toggle" data-on="Active" data-off="Pending" data-onstyle="success" data-offstyle="danger"></a>
                                <?php else: ?>
                                    <a href="" onclick="customerStatus(<?php echo e($row->id); ?>)"><input type="checkbox" data-toggle="toggle" data-on="Active" data-off="Pending" data-onstyle="success" data-offstyle="danger"></a>
                                <?php endif; ?>
                            </td>
                            <td>
                                <a href="<?php echo e(route('admin_customer_detail',$row->id)); ?>" class="btn btn-info btn-sm btn-block"><?php echo e(DETAIL); ?></a>
                                <a href="<?php echo e(route('admin_customer_delete',$row->id)); ?>" class="btn btn-danger btn-sm btn-block" onClick="return confirm('<?php echo e(ARE_YOU_SURE); ?>');"><?php echo e(DELETE); ?></a>
                            </td>
                        </tr>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </tbody>
                </table>
            </div>
        </div>
    </div>

    <script>
        function customerStatus(id){
            $.ajax({
                type:"get",
                url:"<?php echo e(url('/admin/customer-status/')); ?>"+"/"+id,
                success:function(response){
                   toastr.success(response)
                },
                error:function(err){
                    console.log(err);
                }
            })
        }
    </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('admin.app_admin', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH D:\laragon\www\phpscriptpoint\carpoint\carpoint\cms\resources\views/admin/customer_view.blade.php ENDPATH**/ ?>