

<?php $__env->startSection('content'); ?>

<div class="page-banner" style="background-image: url('<?php echo e(asset('uploads/page_banners/'.$blog->banner)); ?>')">
	<div class="page-banner-bg"></div>
	<h1><?php echo e($blog_detail->post_title); ?></h1>
	<nav>
		<ol class="breadcrumb justify-content-center">
			<li class="breadcrumb-item"><a href="<?php echo e(url('/')); ?>"><?php echo e(HOME); ?></a></li>
			<li class="breadcrumb-item"><a href="<?php echo e(route('front_blogs')); ?>"><?php echo e($blog->name); ?></a></li>
			<li class="breadcrumb-item active"><?php echo e($blog_detail->post_title); ?></li>
		</ol>
	</nav>
</div>

<div class="page-content">
	<div class="container">
		<div class="row">
			<div class="col-md-8">
				<div class="blog-item-single">
					<div class="featured-photo">
						<img src="<?php echo e(asset('uploads/post_photos/'.$blog_detail->post_photo)); ?>">
					</div>
					<div class="text">
						<?php echo clean($blog_detail->post_content); ?>

					</div>


					<?php if($blog_detail->comment_show == 'Yes'): ?>
					<div class="comment mt_40">

						<h2 class="mb_25"><?php echo e(count($comments)); ?> <?php echo e(COMMENTS); ?></h2>

						<?php if(count($comments) == 0): ?>
                            <div class="text-danger"><?php echo e(NO_COMMENT_FOUND); ?></div>
                        <?php else: ?>
                        	<?php $__currentLoopData = $comments; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $row): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        		<?php
                        		$gravatar_link = 'http://www.gravatar.com/avatar/' . md5($row->person_email) . '?s=32';
								header("content-type: image/jpeg");
                        		?>
                        		<div class="comment-item">
									<div class="photo">
										<img src="<?php echo e($gravatar_link); ?>">
									</div>
									<div class="text">
										<h4><?php echo e($loop->iteration . '. ' . $row->person_name); ?></h4>
										<div class="date"><?php echo e(\Carbon\Carbon::parse($row->created_at)->format('d M, Y')); ?></div>
										<div class="des">
											<p>
												<?php echo clean(nl2br($row->person_comment)); ?>

											</p>
										</div>
									</div>
								</div>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        <?php endif; ?>


						<h2 class="mt_50 mb_20"><?php echo e(POST_COMMENT); ?></h2>
						<form action="<?php echo e(route('front_comment')); ?>" method="post">
							<?php echo csrf_field(); ?>
							<input type="hidden" name="blog_id" value="<?php echo e($blog_detail->id); ?>">
                            <input type="hidden" name="post_slug" value="<?php echo e($blog_detail->post_slug); ?>">
                            <input type="hidden" name="comment_status" value="Pending">
							<div class="row mb_20">
								<div class="col">
									<label for=""><?php echo e(NAME); ?></label>
									<input type="text" class="form-control" name="person_name">
								</div>
								<div class="col">
									<label for=""><?php echo e(EMAIL); ?></label>
									<input type="email" class="form-control" name="person_email">
								</div>
							</div>
							<div class="row mb_20">
								<div class="col">
									<label for=""><?php echo e(COMMENT); ?></label>
									<textarea name="person_comment" class="form-control h-200" cols="30" rows="10"></textarea>
								</div>
							</div>
							<?php if($g_setting->google_recaptcha_status == 'Show'): ?>
							<div class="row mb_20">
								<div class="col">
									<div class="g-recaptcha" data-sitekey="<?php echo e($g_setting->google_recaptcha_site_key); ?>"></div>
								</div>
							</div>
		                    <?php endif; ?>
							<div class="row">
								<div class="col">
									<button type="submit" class="btn btn-primary"><?php echo e(SUBMIT); ?></button>
								</div>
							</div>
						</form>

					</div>
					<?php endif; ?>

				</div>
			</div>

			<div class="col-md-4">
				<div class="sidebar">
					<div class="widget">
						<h3><?php echo e(CATEGORIES); ?></h3>
						<div class="type-1">
							<ul>
								<?php $__currentLoopData = $categories; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
								<li><a href="<?php echo e(route('front_category',$item->category_slug)); ?>"><?php echo e($item->category_name); ?></a></li>
								<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
							</ul>
						</div>
					</div>
				</div>
			</div>

		</div>
	</div>
</div>

<?php $__env->stopSection(); ?>

<?php echo $__env->make('front.app_front', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/tbooking/globalegyptlimousine.com/resources/views/front/post.blade.php ENDPATH**/ ?>