

<?php $__env->startSection('content'); ?>

<div class="page-banner" style="background-image: url('<?php echo e(asset('uploads/page_banners/'.$pricing_data->banner)); ?>')">
	<div class="page-banner-bg"></div>
	<h1><?php echo e($pricing_data->name); ?></h1>
	<nav>
		<ol class="breadcrumb justify-content-center">
			<li class="breadcrumb-item"><a href="<?php echo e(url('/')); ?>"><?php echo e(HOME); ?></a></li>
			<li class="breadcrumb-item active"><?php echo e($pricing_data->name); ?></li>
		</ol>
	</nav>
</div>

<div class="page-content">
	<div class="container">
		<div class="row pricing">

			<?php $__currentLoopData = $pricing; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $row): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
			<div class="col-lg-4 mb_30">
				<div class="card mb-5 mb-lg-0">
					<div class="card-body">
						<h5 class="card-title text-muted text-uppercase text-center"><?php echo e($row->package_name); ?></h5>
						<h6 class="card-price text-center">
							<?php if(!session()->get('currency_symbol')): ?>
								$<?php echo e(round($row->package_price,2)); ?>

							<?php else: ?>
								<?php echo e(session()->get('currency_symbol')); ?><?php echo e(round($row->package_price*session()->get('currency_value'),2)); ?>

							<?php endif; ?>
							<span class="period">/<?php echo e($row->valid_days); ?> <?php echo e(DAYS); ?></span>
						</h6>
						<hr>
						<ul class="fa-ul">
							<li><span class="fa-li"><i class="fas fa-check"></i></span><?php echo e($row->total_listings); ?> <?php echo e(LISTING_ALLOWED); ?></li>
							<li><span class="fa-li"><i class="fas fa-check"></i></span><?php echo e($row->total_listings); ?> <?php echo e(AMENITIES_PER_LISTING); ?></li>
							<li><span class="fa-li"><i class="fas fa-check"></i></span><?php echo e($row->total_photos); ?> <?php echo e(PHOTOS_PER_LISTING); ?></li>
							<li><span class="fa-li"><i class="fas fa-check"></i></span><?php echo e($row->total_videos); ?> <?php echo e(VIDEOS_PER_LISTING); ?></li>
							<li><span class="fa-li"><i class="fas fa-check"></i></span><?php echo e($row->total_social_items); ?> <?php echo e(SOCIAL_ITEMS_PER_LISTING); ?></li>
							<li><span class="fa-li"><i class="fas fa-check"></i></span><?php echo e($row->total_additional_features); ?> <?php echo e(ADDITIONAL_FEATURES_PER_LISTING); ?></li>
							<li>
								<?php if($row->allow_featured == 'Yes'): ?>
								<span class="fa-li"><i class="fas fa-check"></i></span>
								<?php echo e(FEATURED_LISTING_ALLOWED); ?>

								<?php else: ?>
								<span class="fa-li"><i class="fas fa-times"></i></span>
								<?php echo e(FEATURED_LISTING_NOT_ALLOWED); ?>

								<?php endif; ?>
							</li>
						</ul>
						<a href="<?php echo e(route('customer_package')); ?>" class="btn btn-block btn-primary">
							<?php if($row->package_type == 'Free'): ?>
							<?php echo e(ENROLL_NOW); ?>

							<?php else: ?>
							<?php echo e(BUY_NOW); ?>

							<?php endif; ?>
						</a>
					</div>
				</div>
			</div>
			<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

		</div>
	</div>
</div>

<?php $__env->stopSection(); ?>

<?php echo $__env->make('front.app_front', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/tbooking/globalegyptlimousine.com/resources/views/front/pricing.blade.php ENDPATH**/ ?>