<?php
$g_settings = \App\Models\GeneralSetting::where('id',1)->first();
$dynamic_pages = \App\Models\DynamicPage::get();
$page_about_item = \App\Models\PageAboutItem::where('id',1)->first();
$page_faq_item = \App\Models\PageFaqItem::where('id',1)->first();
$page_blog_item = \App\Models\PageBlogItem::where('id',1)->first();
$page_listing_item = \App\Models\PageListingItem::where('id',1)->first();
$page_pricing_item = \App\Models\PagePricingItem::where('id',1)->first();
$page_contact_item = \App\Models\PageContactItem::where('id',1)->first();
$page_listing_location_item = \App\Models\PageListingLocationItem::where('id',1)->first();
$page_listing_brand_item = \App\Models\PageListingBrandItem::where('id',1)->first();
?>

<!-- Start Navbar Area -->
<div class="navbar-area" id="stickymenu">

	<!-- Menu For Mobile Device -->
	<div class="mobile-nav">
		<a href="<?php echo e(url('/')); ?>" class="logo">
			<img src="<?php echo e(asset('uploads/site_photos/'.$g_settings->logo)); ?>" alt="">
		</a>
	</div>

	<!-- Menu For Desktop Device -->
	<div class="main-nav">
		<div class="container">
			<nav class="navbar navbar-expand-md navbar-light">
				<a class="navbar-brand" href="<?php echo e(url('/')); ?>">
					<img src="<?php echo e(asset('uploads/site_photos/'.$g_settings->logo)); ?>" alt="">
				</a>
				<div class="collapse navbar-collapse mean-menu" id="navbarSupportedContent">
					<ul class="navbar-nav <?php echo e($g_settings->layout_direction == 'ltr' ? 'ml-auto' : 'mr-auto'); ?>">

						<li class="nav-item">
							<a href="<?php echo e(url('/')); ?>" class="nav-link"><?php echo e(MENU_HOME); ?></a>
						</li>

                        <?php if($page_listing_item->status == 'Show'): ?>
						<li class="nav-item">
							<a href="<?php echo e(url('listing-result')); ?>" class="nav-link"><?php echo e(MENU_LISTING); ?></a>
						</li>
                        <?php endif; ?>

                        <?php if($page_pricing_item->status == 'Show'): ?>
						<li class="nav-item">
							<a href="<?php echo e(route('front_pricing')); ?>" class="nav-link"><?php echo e(MENU_PRICING); ?></a>
						</li>
                        <?php endif; ?>

						<?php if($page_faq_item->status == 'Show'): ?>
						<li class="nav-item">
							<a href="<?php echo e(route('front_faq')); ?>" class="nav-link"><?php echo e(MENU_FAQ); ?></a>
						</li>
						<?php endif; ?>

                        <?php if($page_listing_location_item->status == 'Show' || $page_listing_brand_item->status == 'Show' || (!$dynamic_pages->isEmpty())): ?>
						<li class="nav-item">
							<a href="javascript:void;" class="nav-link dropdown-toggle"><?php echo e(MENU_PAGES); ?></a>
							<ul class="dropdown-menu">

                                <?php if($page_listing_location_item->status == 'Show'): ?>
								<li class="nav-item">
									<a href="<?php echo e(route('front_listing_location_all')); ?>" class="nav-link"><?php echo e(MENU_LOCATION); ?></a>
								</li>
                                <?php endif; ?>

                                <?php if($page_listing_brand_item->status == 'Show'): ?>
								<li class="nav-item">
									<a href="<?php echo e(route('front_listing_brand_all')); ?>" class="nav-link"><?php echo e(MENU_BRAND); ?></a>
								</li>
                                <?php endif; ?>

                                <?php if(!$dynamic_pages->isEmpty()): ?>
								<?php $__currentLoopData = $dynamic_pages; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $row): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <li class="nav-item">
                                        <a href="<?php echo e(url('page/'.$row->dynamic_page_slug)); ?>" class="nav-link"><?php echo e($row->dynamic_page_name); ?></a>
                                    </li>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                <?php endif; ?>
							</ul>
						</li>
                        <?php endif; ?>

						<?php if($page_blog_item->status == 'Show'): ?>
						<li class="nav-item">
							<a href="<?php echo e(route('front_blogs')); ?>" class="nav-link"><?php echo e(MENU_BLOG); ?></a>
						</li>
						<?php endif; ?>

                        <?php if($page_contact_item->status == 'Show'): ?>
						<li class="nav-item">
							<a href="<?php echo e(route('front_contact')); ?>" class="nav-link"><?php echo e(MENU_CONTACT); ?></a>
						</li>
                        <?php endif; ?>

					</ul>
				</div>
			</nav>
		</div>
	</div>
</div>
<!-- End Navbar Area -->
<?php /**PATH D:\laragon\www\phpscriptpoint\carpoint\carpoint\cms\resources\views/front/app_nav.blade.php ENDPATH**/ ?>