
<?php $__env->startSection('admin_content'); ?>
    <h1 class="h3 mb-3 text-gray-800"><?php echo e(LISTING); ?></h1>

    <div class="card shadow mb-4">
        <div class="card-header py-3">
            <h6 class="m-0 mt-2 font-weight-bold text-primary"></h6>
            <div class="float-right d-inline">
                <a href="<?php echo e(route('admin_listing_create')); ?>" class="btn btn-primary btn-sm"><i class="fa fa-plus"></i> <?php echo e(ADD_NEW); ?></a>
            </div>
        </div>
        <div class="card-body">
            <div class="table-responsive">
                <table class="table table-bordered" id="dataTable" width="100%" cellspacing="0">
                    <thead>
                        <tr>
                            <th><?php echo e(SERIAL); ?></th>
                            <th><?php echo e(FEATURED_PHOTO); ?></th>
                            <th><?php echo e(NAME); ?>, <?php echo e(BRAND); ?>, <?php echo e(LOCATION); ?></th>
                            <th><?php echo e(STATUS); ?></th>
                            <th><?php echo e(QUESTION_IS_FEATURED); ?></th>
                            <th class="w_200"><?php echo e(ACTION); ?></th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php $i=0; ?>

                        <?php $__currentLoopData = $listing; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $row): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>

                        <?php $i++; ?>

                        <?php
                        $user_detail = \App\Models\User::where('id',$row->user_id)->first();
                        $admin_detail = \App\Models\Admin::where('id',$row->admin_id)->first();
                        ?>

                        <tr>
                            <td><?php echo e($loop->iteration); ?></td>
                            <td><img src="<?php echo e(asset('uploads/listing_featured_photos/'.$row->listing_featured_photo)); ?>" alt="" class="w_200"></td>
                            <td>
                                <?php if($row->user_id==0): ?>
                                <b><?php echo e($row->listing_name); ?></b><br>
                                <small>
                                    <b><?php echo e(ADDED_BY); ?>: <?php echo e(ADMIN); ?></b>
                                </small>
                                <?php endif; ?>

                                <?php if($row->admin_id==0): ?>
                                <b><?php echo e($row->listing_name); ?></b><br>
                                <small><b><?php echo e(ADDED_BY); ?>: <a href="<?php echo e(route('admin_customer_detail',$row->user_id)); ?>" target="_blank"><?php echo e($user_detail->name); ?></a></b></small>
                                <?php endif; ?>

                                <br>
                                <?php echo e(BRAND_COLON); ?> <?php echo e($row->rListingBrand->listing_brand_name); ?>

                                <br>
                                <?php echo e(LOCATION_COLON); ?> <?php echo e($row->rListingLocation->listing_location_name); ?>

                            </td>
                            <td>
                                <?php if($row->listing_status == 'Active'): ?>
                                <a href="" onclick="listingStatus(<?php echo e($row->id); ?>)"><input type="checkbox" checked data-toggle="toggle" data-on="Active" data-off="Pending" data-onstyle="success" data-offstyle="danger"></a>
                                <?php else: ?>
                                    <a href="" onclick="listingStatus(<?php echo e($row->id); ?>)"><input type="checkbox" data-toggle="toggle" data-on="Active" data-off="Pending" data-onstyle="success" data-offstyle="danger"></a>
                                <?php endif; ?>
                            </td>
                            <td>
                                <?php if($row->is_featured == 'Yes'): ?>
                                <span class="badge badge-success"><?php echo e($row->is_featured); ?></span>
                                <?php else: ?>
                                <span class="badge badge-danger"><?php echo e($row->is_featured); ?></span>
                                <?php endif; ?>
                            </td>
                            <td>
                                <a href="" class="btn btn-success btn-sm" data-toggle="modal" data-target="#detail_info<?php echo e($row->id); ?>"><i class="fas fa-eye"></i></a>
                                <a href="<?php echo e(route('admin_listing_delete',$row->id)); ?>" class="btn btn-danger btn-sm" onClick="return confirm('<?php echo e(ARE_YOU_SURE); ?>');"><i class="fas fa-trash-alt"></i></a>

                                <a href="<?php echo e(route('admin_listing_edit',$row->id)); ?>" class="btn btn-warning btn-sm"><i class="fas fa-edit"></i></a>
                            </td>
                        </tr>

<!-- Modal -->
<div class="modal fade modal_listing_detail" id="detail_info<?php echo e($row->id); ?>" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel" aria-hidden="true">
    <div class="modal-dialog modal-lg" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="exampleModalLabel"><?php echo e(LISTING_DETAIL); ?></h5>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>
            <div class="modal-body">

                <div class="form-group">
                    <label for=""><?php echo e(NAME); ?></label>
                    <div><?php echo e($row->listing_name); ?></div>
                </div>

                <div class="form-group">
                    <label for=""><?php echo e(SLUG); ?></label>
                    <div><?php echo e($row->listing_slug); ?></div>
                </div>

                <div class="form-group">
                    <label for=""><?php echo e(DESCRIPTION); ?></label>
                    <div><?php echo clean($row->listing_description); ?></div>
                </div>

                <div class="form-group">
                    <label for=""><?php echo e(LISTING_BRAND); ?></label>
                    <div><?php echo e($row->rListingBrand->listing_brand_name); ?></div>
                </div>

                <div class="form-group">
                    <label for=""><?php echo e(LISTING_LOCATION); ?></label>
                    <div><?php echo e($row->rListingLocation->listing_location_name); ?></div>
                </div>

                <?php if($row->listing_address != ''): ?>
                <div class="form-group">
                    <label for=""><?php echo e(ADDRESS); ?></label>
                    <div><?php echo clean(nl2br($row->listing_address)); ?></div>
                </div>
                <?php endif; ?>

                <?php if($row->listing_phone != ''): ?>
                <div class="form-group">
                    <label for=""><?php echo e(PHONE); ?></label>
                    <div><?php echo clean(nl2br($row->listing_phone)); ?></div>
                </div>
                <?php endif; ?>

                <?php if($row->listing_email != ''): ?>
                <div class="form-group">
                    <label for=""><?php echo e(EMAIL); ?></label>
                    <div><?php echo clean(nl2br($row->listing_email)); ?></div>
                </div>
                <?php endif; ?>

                <?php if($row->listing_map != ''): ?>
                <div class="form-group">
                    <label for=""><?php echo e(MAP); ?></label>
                    <div><?php echo $row->listing_map; ?></div>
                </div>
                <?php endif; ?>

                <?php if($row->listing_website != ''): ?>
                <div class="form-group">
                    <label for=""><?php echo e(WEBSITE); ?></label>
                    <div><a href="<?php echo e($row->listing_website); ?>" target="_blank"><?php echo e($row->listing_website); ?></a></div>
                </div>
                <?php endif; ?>

                <div class="form-group">
                    <label for=""><?php echo e(FEATURED_PHOTO); ?></label>
                    <div><img src="<?php echo e(asset('uploads/listing_featured_photos/'.$row->listing_featured_photo)); ?>" alt="" class="w_200"></div>
                </div>


                <div class="form-group">
                    <label for=""><?php echo e(FEATURES); ?></label>

                    <div class="row bdb bdt">
                        <div class="col-md-3"><b><?php echo e(PRICE); ?></b>:</div>
                        <div class="col-md-9"><?php echo e($row->listing_price); ?></div>
                    </div>

                    <div class="row bdb">
                        <div class="col-md-3"><b><?php echo e(TYPE); ?></b>:</div>
                        <div class="col-md-9"><?php echo e($row->listing_type); ?></div>
                    </div>

                    <?php if($row->listing_exterior_color != ''): ?>
                    <div class="row bdb">
                        <div class="col-md-3"><b><?php echo e(EXTERIOR_COLOR); ?></b>:</div>
                        <div class="col-md-9"><?php echo e($row->listing_exterior_color); ?></div>
                    </div>
                    <?php endif; ?>

                    <?php if($row->listing_interior_color != ''): ?>
                    <div class="row bdb">
                        <div class="col-md-3"><b><?php echo e(INTERIOR_COLOR); ?></b>:</div>
                        <div class="col-md-9"><?php echo e($row->listing_interior_color); ?></div>
                    </div>
                    <?php endif; ?>

                    <?php if($row->listing_cylinder != ''): ?>
                    <div class="row bdb">
                        <div class="col-md-3"><b><?php echo e(CYLINDER); ?></b>:</div>
                        <div class="col-md-9"><?php echo e($row->listing_cylinder); ?></div>
                    </div>
                    <?php endif; ?>

                    <?php if($row->listing_fuel_type != ''): ?>
                    <div class="row bdb">
                        <div class="col-md-3"><b><?php echo e(FUEL_TYPE); ?></b>:</div>
                        <div class="col-md-9"><?php echo e($row->listing_fuel_type); ?></div>
                    </div>
                    <?php endif; ?>

                    <?php if($row->listing_transmission != ''): ?>
                    <div class="row bdb">
                        <div class="col-md-3"><b><?php echo e(TRANSMISSION); ?></b>:</div>
                        <div class="col-md-9"><?php echo e($row->listing_transmission); ?></div>
                    </div>
                    <?php endif; ?>

                    <?php if($row->listing_engine_capacity != ''): ?>
                    <div class="row bdb">
                        <div class="col-md-3"><b><?php echo e(ENGINE_CAPACITY); ?></b>:</div>
                        <div class="col-md-9"><?php echo e($row->listing_engine_capacity); ?></div>
                    </div>
                    <?php endif; ?>

                    <?php if($row->listing_vin != ''): ?>
                    <div class="row bdb">
                        <div class="col-md-3"><b><?php echo e(VIN); ?></b>:</div>
                        <div class="col-md-9"><?php echo e($row->listing_vin); ?></div>
                    </div>
                    <?php endif; ?>

                    <?php if($row->listing_body != ''): ?>
                    <div class="row bdb">
                        <div class="col-md-3"><b><?php echo e(BODY); ?></b>:</div>
                        <div class="col-md-9"><?php echo e($row->listing_body); ?></div>
                    </div>
                    <?php endif; ?>

                    <?php if($row->listing_seat != ''): ?>
                    <div class="row bdb">
                        <div class="col-md-3"><b><?php echo e(SEAT); ?></b>:</div>
                        <div class="col-md-9"><?php echo e($row->listing_seat); ?></div>
                    </div>
                    <?php endif; ?>

                    <?php if($row->listing_wheel != ''): ?>
                    <div class="row bdb">
                        <div class="col-md-3"><b><?php echo e(WHEEL); ?></b>:</div>
                        <div class="col-md-9"><?php echo e($row->listing_wheel); ?></div>
                    </div>
                    <?php endif; ?>

                    <?php if($row->listing_door != ''): ?>
                    <div class="row bdb">
                        <div class="col-md-3"><b><?php echo e(DOOR); ?></b>:</div>
                        <div class="col-md-9"><?php echo e($row->listing_door); ?></div>
                    </div>
                    <?php endif; ?>

                    <?php if($row->listing_mileage != ''): ?>
                    <div class="row bdb">
                        <div class="col-md-3"><b><?php echo e(MILEAGE); ?></b>:</div>
                        <div class="col-md-9"><?php echo e($row->listing_mileage); ?></div>
                    </div>
                    <?php endif; ?>

                    <?php if($row->listing_model_year != ''): ?>
                    <div class="row bdb">
                        <div class="col-md-3"><b><?php echo e(MODEL_YEAR); ?></b>:</div>
                        <div class="col-md-9"><?php echo e($row->listing_model_year); ?></div>
                    </div>
                    <?php endif; ?>
                    
                </div>



                <div class="form-group">
                    <label for=""><?php echo e(OPENING_HOUR); ?></label>

                    <div class="row bdb bdt">
                        <div class="col-md-3">
                            <b><?php echo e(MONDAY); ?></b>:
                        </div>
                        <div class="col-md-9">
                            <?php echo e($row->listing_oh_monday); ?>

                        </div>
                    </div>

                    <div class="row bdb">
                        <div class="col-md-3">
                            <b><?php echo e(TUESDAY); ?></b>:
                        </div>
                        <div class="col-md-9">
                            <?php echo e($row->listing_oh_tuesday); ?>

                        </div>
                    </div>

                    <div class="row bdb">
                        <div class="col-md-3">
                            <b><?php echo e(WEDNESDAY); ?></b>:
                        </div>
                        <div class="col-md-9">
                            <?php echo e($row->listing_oh_wednesday); ?>

                        </div>
                    </div>

                    <div class="row bdb">
                        <div class="col-md-3">
                            <b><?php echo e(THURSDAY); ?></b>:
                        </div>
                        <div class="col-md-9">
                            <?php echo e($row->listing_oh_thursday); ?>

                        </div>
                    </div>

                    <div class="row bdb">
                        <div class="col-md-3">
                            <b><?php echo e(FRIDAY); ?></b>:
                        </div>
                        <div class="col-md-9">
                            <?php echo e($row->listing_oh_friday); ?>

                        </div>
                    </div>

                    <div class="row bdb">
                        <div class="col-md-3">
                            <b><?php echo e(SATURDAY); ?></b>:
                        </div>
                        <div class="col-md-9">
                            <?php echo e($row->listing_oh_saturday); ?>

                        </div>
                    </div>

                    <div class="row bdb">
                        <div class="col-md-3">
                            <b><?php echo e(SUNDAY); ?></b>:
                        </div>
                        <div class="col-md-9">
                            <?php echo e($row->listing_oh_sunday); ?>

                        </div>
                    </div>

                </div>


                <div class="form-group">
                    <label for=""><?php echo e(SOCIAL_MEDIA); ?></label>
                    <?php
                    $i=0;
                    $social_items = DB::table('listing_social_items')->where('listing_id',$row->id)->get();
                    ?>
                    <?php $__currentLoopData = $social_items; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <?php $i++; ?>
                    <div class="row bdb <?php if($i==1): ?> bdt <?php endif; ?>">
                        <div class="col-md-3">
                            <?php echo e($item->social_icon); ?>

                        </div>
                        <div class="col-md-9">
                            <a href="<?php echo e($item->social_url); ?>" target="_blank"><?php echo e(URL_TO_CLICK); ?></a>
                        </div>
                    </div>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </div>


                <div class="form-group">
                    <label for=""><?php echo e(AMENITIES); ?></label>
                    <?php
                    $i=0;
                    $amenities = DB::table('listing_amenities')
                        ->join('amenities','listing_amenities.amenity_id','amenities.id')
                        ->select('listing_amenities.*', 'amenities.amenity_name')
                        ->where('listing_amenities.listing_id',$row->id)
                        ->get();
                    ?>
                    <?php $__currentLoopData = $amenities; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <?php $i++; ?>
                    <div class="row bdb <?php if($i==1): ?> bdt <?php endif; ?>">
                        <div class="col-md-12">
                            <?php echo e($i.'. '.$item->amenity_name); ?>

                        </div>
                    </div>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </div>


                <div class="form-group">
                    <label for=""><?php echo e(PHOTO); ?>s</label>

                    <?php
                    $photos = DB::table('listing_photos')->where('listing_id',$row->id)->get();
                    ?>

                    <div class="row">
                        <?php $__currentLoopData = $photos; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <div class="col-md-4">
                            <div class="mb_10">
                                <img src="<?php echo e(asset('uploads/listing_photos/'.$item->photo)); ?>" alt="" class="w_100_p">
                            </div>
                        </div>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </div>
                </div>


                <div class="form-group">
                    <label for=""><?php echo e(VIDEOS); ?></label>

                    <?php
                    $videos = DB::table('listing_videos')->where('listing_id',$row->id)->get();
                    ?>

                    <div class="row">
                        <?php $__currentLoopData = $videos; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <div class="col-md-4">
                            <div class="mb_10 existing-video">
                                <iframe width="560" height="315" src="https://www.youtube.com/embed/<?php echo e($item->youtube_video_id); ?>" title="<?php echo e(YOUTUBE_VIDEO_PLAYER); ?>" frameborder="0" allow="accelerometer; autoplay; clipboard-write; encrypted-media; gyroscope; picture-in-picture" allowfullscreen></iframe>
                            </div>
                        </div>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </div>
                </div>


                <div class="form-group">
                    <label for=""><?php echo e(ADDITIONAL_FEATURES); ?></label>

                    <?php
                    $i=0;
                    $additional_features = DB::table('listing_additional_features')->where('listing_id',$row->id)->get();
                    ?>

                    <?php $__currentLoopData = $additional_features; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <?php $i++; ?>
                    <div class="row bdb <?php if($i==1): ?> bdt <?php endif; ?>">
                    <div class="col-md-3">
                        <?php echo e($item->additional_feature_name); ?>

                    </div>
                    <div class="col-md-9">
                        <?php echo e($item->additional_feature_value); ?>

                    </div>
                    </div>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                </div>



            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-danger btn-sm" data-dismiss="modal"><?php echo e(CLOSE); ?></button>
            </div>
        </div>
    </div>
</div>
<!-- // Modal -->


                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </tbody>
                </table>
            </div>
        </div>
    </div>

    <script>
        function listingStatus(id){
            $.ajax({
                type:"get",
                url:"<?php echo e(url('/admin/listing-status/')); ?>"+"/"+id,
                success:function(response){
                   toastr.success(response)
                },
                error:function(err){
                    console.log(err);
                }
            })
        }
    </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('admin.app_admin', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/tbooking/globalegyptlimousine.com/resources/views/admin/listing_view.blade.php ENDPATH**/ ?>