<?php
$g_settings = \App\Models\GeneralSetting::where('id',1)->first();
$social_media = \App\Models\SocialMediaItem::orderBy('social_order', 'asc')->get();
$listing_brands = \App\Models\ListingBrand::orderBy('listing_brand_name','asc')->skip(0)->take(5)->get();
$listing_locations = \App\Models\ListingLocation::orderBy('listing_location_name','asc')->skip(0)->take(5)->get();
$page_faq_item = \App\Models\PageFaqItem::where('id',1)->first();
$page_blog_item = \App\Models\PageBlogItem::where('id',1)->first();
$page_privacy_item = \App\Models\PagePrivacyItem::where('id',1)->first();
$page_term_item = \App\Models\PageTermItem::where('id',1)->first();
$page_about_item = \App\Models\PageAboutItem::where('id',1)->first();
?>

<div class="footer-area">
	<div class="container">
		<div class="row">
			<div class="col-lg-3 col-md-4 col-sm-6">
				<div class="footer-item footer-service">
					<h2><?php echo e($g_settings->footer_column_1_heading); ?></h2>
					<ul class="fmain">
                        <?php $i=0; ?>
						<?php $__currentLoopData = $listing_brands; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $row): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <?php $i++; ?>
                            <?php if($i>$g_settings->footer_column_1_total_item): ?>
                                <?php break; ?>
                            <?php endif; ?>
						    <li>
                                <a href="<?php echo e(route('front_listing_brand_detail',$row->listing_brand_slug)); ?>"><?php echo e($row->listing_brand_name); ?></a>
                            </li>
						<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
					</ul>
				</div>
			</div>
			<div class="col-lg-3 col-md-4 col-sm-6">
				<div class="footer-item footer-service">
					<h2><?php echo e($g_settings->footer_column_2_heading); ?></h2>
					<ul class="fmain">
                        <?php $i=0; ?>
						<?php $__currentLoopData = $listing_locations; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $row): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <?php $i++; ?>
                            <?php if($i>$g_settings->footer_column_2_total_item): ?>
                                <?php break; ?>
                            <?php endif; ?>
						    <li><a href="<?php echo e(route('front_listing_location_detail',$row->listing_location_slug)); ?>"><?php echo e($row->listing_location_name); ?></a></li>
						<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
					</ul>
				</div>
			</div>
			<div class="col-lg-3 col-md-4 col-sm-6">
				<div class="footer-item footer-service">
					<h2><?php echo e($g_settings->footer_column_3_heading); ?></h2>
					<ul class="fmain">
						<li><a href="<?php echo e(url('/')); ?>"><?php echo e(MENU_HOME); ?></a></li>

						<?php if($page_about_item->status == 'Show'): ?>
						<li><a href="<?php echo e(route('front_about')); ?>"><?php echo e(MENU_ABOUT); ?></a></li>
                        <?php endif; ?>

                        <?php if($page_privacy_item->status == 'Show'): ?>
						<li><a href="<?php echo e(route('front_privacy_policy')); ?>"><?php echo e(MENU_PRIVACY_POLICY); ?></a></li>
                        <?php endif; ?>

                        <?php if($page_term_item->status == 'Show'): ?>
						<li><a href="<?php echo e(route('front_terms_and_conditions')); ?>"><?php echo e(MENU_TERMS_AND_CONDITIONS); ?></a></li>
                        <?php endif; ?>

                        <?php if($page_blog_item->status == 'Show'): ?>
						<li><a href="<?php echo e(route('front_blogs')); ?>"><?php echo e(MENU_BLOG); ?></a></li>
                        <?php endif; ?>

					</ul>
				</div>
			</div>
			<div class="col-lg-3 col-md-4 col-sm-6">
				<div class="footer-item footer-contact">
					<h2><?php echo e($g_settings->footer_column_4_heading); ?></h2>
					<ul>
						<li>
							<?php echo clean(nl2br($g_settings->footer_address)); ?>

						</li>
						<li>
							<?php echo clean(nl2br($g_settings->footer_email)); ?>

						</li>
						<li>
							<?php echo clean(nl2br($g_settings->footer_phone)); ?>

						</li>
					</ul>
				</div>
				<div class="footer-item footer-service">
					<div class="footer-social-link">
						<ul>
							<?php $__currentLoopData = $social_media; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $row): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <li><a href="<?php echo e($row->social_url); ?>" target="_blank"><i class="<?php echo e($row->social_icon); ?>"></i></a></li>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
						</ul>
					</div>
				</div>
			</div>
		</div>
		<div class="row">
			<div class="col-md-12">
				<div class="copyright">
					<p><?php echo e($g_settings->footer_copyright); ?></p>
				</div>
			</div>
		</div>
	</div>
</div>
<?php /**PATH D:\laragon\www\phpscriptpoint\carpoint\carpoint\cms\resources\views/front/app_footer.blade.php ENDPATH**/ ?>