

<?php $__env->startSection('content'); ?>

<?php if($agent_detail->banner == ''): ?>
	<?php $banner = 'default_banner.jpg'; ?>
<?php else: ?>
	<?php $banner = $agent_detail->banner; ?>
<?php endif; ?>

<div class="agent-banner" style="background-image: url('<?php echo e(asset('uploads/user_photos/'.$banner)); ?>');">
	<div class="bg"></div>
	<div class="container">
		<div class="row">
			<div class="col-lg-6 col-md-12">
				<div class="agent">
					<div class="photo">
						<?php if($agent_detail->photo == ''): ?>
							<img src="<?php echo e(asset('uploads/user_photos/default_photo.jpg')); ?>" alt="">
						<?php else: ?>
							<img src="<?php echo e(asset('uploads/user_photos/'.$agent_detail->photo)); ?>" alt="">
						<?php endif; ?>
					</div>
					<div class="text">
						<h3><?php echo e($agent_detail->name); ?></h3>
						<h4><?php echo e(REGISTERED_ON); ?> <?php echo e(\Carbon\Carbon::parse($agent_detail->created_at)->format('d M, Y')); ?></h4>
					</div>
				</div>

				<?php if( ($agent_detail->facebook != '') ||
				($agent_detail->twitter != '') ||
				($agent_detail->linkedin != '') ||
				($agent_detail->pinterest != '') ||
				($agent_detail->youtube != '') ): ?>
				<div class="social">
					<ul>
						<?php if($agent_detail->facebook != ''): ?>
						<li><a href="<?php echo e($agent_detail->facebook); ?>" target="_blank"><i class="fab fa-facebook-f"></i></a></li>
						<?php endif; ?>

						<?php if($agent_detail->twitter != ''): ?>
						<li><a href="<?php echo e($agent_detail->twitter); ?>" target="_blank"><i class="fab fa-twitter"></i></a></li>
						<?php endif; ?>

						<?php if($agent_detail->linkedin != ''): ?>
						<li><a href="<?php echo e($agent_detail->linkedin); ?>" target="_blank"><i class="fab fa-linkedin-in"></i></a></li>
						<?php endif; ?>

						<?php if($agent_detail->pinterest != ''): ?>
						<li><a href="<?php echo e($agent_detail->pinterest); ?>" target="_blank"><i class="fab fa-pinterest-p"></i></a></li>
						<?php endif; ?>

						<?php if($agent_detail->youtube != ''): ?>
						<li><a href="<?php echo e($agent_detail->youtube); ?>" target="_blank"><i class="fab fa-youtube"></i></a></li>
						<?php endif; ?>
					</ul>
				</div>
				<?php endif; ?>
			</div>
			<div class="col-lg-6 col-md-12">
				<div class="contact">
					<?php if($agent_detail->address != ''): ?>
					<div class="item"><i class="fas fa-map-marker-alt"></i> <?php echo e($agent_detail->address); ?></div>
					<?php endif; ?>

					<?php if($agent_detail->phone != ''): ?>
					<div class="item"><i class="fas fa-phone-volume"></i> <?php echo e($agent_detail->phone); ?></div>
					<?php endif; ?>

					<?php if($agent_detail->email != ''): ?>
					<div class="item"><i class="fas fa-envelope"></i> <?php echo e($agent_detail->email); ?></div>
					<?php endif; ?>

					<?php if($agent_detail->website != ''): ?>
					<div class="item"><i class="fas fa-globe"></i> <?php echo e($agent_detail->website); ?></div>
					<?php endif; ?>
				</div>
			</div>
		</div>
	</div>
</div>

<div class="page-content">
	<div class="container">
		<div class="row listing pb_0">

			<?php $__currentLoopData = $all_listings; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $row): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
			<div class="col-lg-4 col-md-6 col-sm-12">
				<div class="listing-item">
					<div class="photo">
						<a href="<?php echo e(route('front_listing_detail',$row->listing_slug)); ?>"><img src="<?php echo e(asset('uploads/listing_featured_photos/'.$row->listing_featured_photo)); ?>" alt=""></a>
						<div class="brand">
							<a href="<?php echo e(route('front_listing_brand_detail',$row->rListingBrand->listing_brand_slug)); ?>"><?php echo e($row->rListingBrand->listing_brand_name); ?></a>
						</div>
						<div class="wishlist">
							<a href="<?php echo e(route('front_add_wishlist',$row->id)); ?>"><i class="fas fa-heart"></i></a>
						</div>
                        <?php if($row->is_featured == 'Yes'): ?>
                        <div class="featured-text"><?php echo e(FEATURED); ?></div>
                        <?php endif; ?>
					</div>
					<div class="text">

                        <div class="type-price">
                            <div class="type">
                                <?php if($row->listing_type == '12 Hours'): ?>
                                <div class="inner-new">
                                    <?php echo e($row->listing_type); ?>

                                </div>
                                <?php else: ?>
                                <div class="inner-used">
                                    <?php echo e($row->listing_type); ?>

                                </div>
                                <?php endif; ?>
                            </div>
                            <div class="price">
                                <?php if(!session()->get('currency_symbol')): ?>
                                    $<?php echo e(number_format($row->listing_price)); ?>

                                <?php else: ?>
                                    <?php echo e(session()->get('currency_symbol')); ?><?php echo e(number_format($row->listing_price*session()->get('currency_value'))); ?>

                                <?php endif; ?>
                            </div>
                        </div>
                        
						<h3><a href="<?php echo e(route('front_listing_detail',$row->listing_slug)); ?>"><?php echo e($row->listing_name); ?></a></h3>
						<div class="location">
							<a href="<?php echo e(route('front_listing_location_detail',$row->rListingLocation->listing_location_slug)); ?>"><i class="fas fa-map-marker-alt"></i> <?php echo e($row->rListingLocation->listing_location_name); ?></a>
						</div>

                        <?php
                            $count=0;
                            $total_number = 0;
                            $overall_rating = 0;
                            $reviews = \App\Models\Review::where('listing_id',$row->id)->get();
                        ?>

                        <?php if($reviews->isEmpty()): ?>

                        <?php else: ?>

                            <?php $__currentLoopData = $reviews; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <?php
                                    $count++;
                                    $total_number = $total_number + $item->rating;
                                ?>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                            <?php
                                $overall_rating = $total_number/$count;
                            ?>

                            <?php if($overall_rating>0 && $overall_rating<=1): ?>
                                <?php $overall_rating = 1; ?>

                            <?php elseif($overall_rating>1 && $overall_rating<=1.5): ?>
                                <?php $overall_rating = 1.5; ?>

                            <?php elseif($overall_rating>1.5 && $overall_rating<=2): ?>
                                <?php $overall_rating = 2; ?>

                            <?php elseif($overall_rating>2 && $overall_rating<=2.5): ?>
                                <?php $overall_rating = 2.5; ?>

                            <?php elseif($overall_rating>2.5 && $overall_rating<=3): ?>
                                <?php $overall_rating = 3; ?>

                            <?php elseif($overall_rating>3 && $overall_rating<=3.5): ?>
                                <?php $overall_rating = 3.5; ?>

                            <?php elseif($overall_rating>3.5 && $overall_rating<=4): ?>
                                <?php $overall_rating = 4; ?>

                            <?php elseif($overall_rating>4 && $overall_rating<=4.5): ?>
                                <?php $overall_rating = 4.5; ?>

                            <?php elseif($overall_rating>4.5 && $overall_rating<=5): ?>
                                <?php $overall_rating = 5; ?>

                            <?php endif; ?>

                        <?php endif; ?>

                        <div class="review">
                            <?php if($overall_rating == 5): ?>
                                <i class="fas fa-star"></i>
                                <i class="fas fa-star"></i>
                                <i class="fas fa-star"></i>
                                <i class="fas fa-star"></i>
                                <i class="fas fa-star"></i>
                            <?php elseif($overall_rating == 4.5): ?>
                                <i class="fas fa-star"></i>
                                <i class="fas fa-star"></i>
                                <i class="fas fa-star"></i>
                                <i class="fas fa-star"></i>
                                <i class="fas fa-star-half-alt"></i>
                            <?php elseif($overall_rating == 4): ?>
                                <i class="fas fa-star"></i>
                                <i class="fas fa-star"></i>
                                <i class="fas fa-star"></i>
                                <i class="fas fa-star"></i>
                                <i class="far fa-star"></i>
                            <?php elseif($overall_rating == 3.5): ?>
                                <i class="fas fa-star"></i>
                                <i class="fas fa-star"></i>
                                <i class="fas fa-star"></i>
                                <i class="fas fa-star-half-alt"></i>
                                <i class="far fa-star"></i>
                            <?php elseif($overall_rating == 3): ?>
                                <i class="fas fa-star"></i>
                                <i class="fas fa-star"></i>
                                <i class="fas fa-star"></i>
                                <i class="far fa-star"></i>
                                <i class="far fa-star"></i>
                            <?php elseif($overall_rating == 2.5): ?>
                                <i class="fas fa-star"></i>
                                <i class="fas fa-star"></i>
                                <i class="fas fa-star-half-alt"></i>
                                <i class="far fa-star"></i>
                                <i class="far fa-star"></i>
                            <?php elseif($overall_rating == 2): ?>
                                <i class="fas fa-star"></i>
                                <i class="fas fa-star"></i>
                                <i class="far fa-star"></i>
                                <i class="far fa-star"></i>
                                <i class="far fa-star"></i>
                            <?php elseif($overall_rating == 1.5): ?>
                                <i class="fas fa-star"></i>
                                <i class="fas fa-star-half-alt"></i>
                                <i class="far fa-star"></i>
                                <i class="far fa-star"></i>
                                <i class="far fa-star"></i>
                            <?php elseif($overall_rating == 1): ?>
                                <i class="fas fa-star"></i>
                                <i class="far fa-star"></i>
                                <i class="far fa-star"></i>
                                <i class="far fa-star"></i>
                                <i class="far fa-star"></i>
                            <?php elseif($overall_rating == 0): ?>
                                <i class="far fa-star"></i>
                                <i class="far fa-star"></i>
                                <i class="far fa-star"></i>
                                <i class="far fa-star"></i>
                                <i class="far fa-star"></i>
                            <?php endif; ?>
                            <span>(<?php echo e($count); ?> <?php echo e(REVIEWS); ?>)</span>
                        </div>

					</div>
				</div>
			</div>
			<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>


		</div>
	</div>
</div>

<?php $__env->stopSection(); ?>

<?php echo $__env->make('front.app_front', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/tbooking/globalegyptlimousine.com/resources/views/front/listing_agent_detail.blade.php ENDPATH**/ ?>