<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="utf-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">

    <title><?php echo e(LOGIN); ?></title>

    <?php echo $__env->make('admin.app_styles', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

    <link href="https://fonts.googleapis.com/css2?family=DM+Sans:wght@400;500;700&display=swap" rel="stylesheet">

    <?php echo $__env->make('admin.app_scripts', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

</head>

    <body class="bg-gradient-primary">
        <div class="container v-center">
            <!-- Outer Row -->
            <div class="row justify-content-center">
                <div class="col-xl-5 col-lg-5 col-md-5">
                    <div class="card o-hidden border-0 shadow-lg my-5">
                        <div class="card-body p-0">
                            <!-- Nested Row within Card Body -->
                            <div class="row">
                                <div class="col-lg-12">
                                    <div class="p-5">

                                        <div class="text-center">
                                            <h1 class="h4 text-gray-900 mb-4"><?php echo e(ADMIN_LOGIN); ?></h1>
                                        </div>

                                        <form action="<?php echo e(route('admin_login_store')); ?>" class="user" method="post">
                                            <?php echo csrf_field(); ?>
                                            <div class="form-group">
                                                <input id="email" type="email" class="form-control form-control-user" name="email" value="<?php echo e(old('email')); ?>" autocomplete="email" autofocus placeholder="<?php echo e(EMAIL_ADDRESS); ?>">
                                            </div>
                                            <div class="form-group">
                                                <input id="password" type="password" class="form-control form-control-user" name="password" placeholder="<?php echo e(PASSWORD); ?>">
                                            </div>
                                            <button type="submit" class="btn btn-primary btn-user btn-block"><?php echo e(LOGIN); ?></button>
                                        </form>
                                        <hr>
                                        <div class="text-center">
                                            <a class="font-weight-bold" href="<?php echo e(route('admin_forget_password')); ?>"><?php echo e(FORGET_PASSWORD); ?></a>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>

                </div>

            </div>

        </div>

        <?php echo $__env->make('admin.app_scripts_footer', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

</body>
</html><?php /**PATH D:\laragon\www\phpscriptpoint\carpoint\carpoint\cms\resources\views/admin/login.blade.php ENDPATH**/ ?>