

<?php $__env->startSection('content'); ?>

<div class="page-banner" style="background-image: url('<?php echo e(asset('uploads/page_banners/'.$listing_page_data->banner)); ?>')">
    <div class="page-banner-bg"></div>
    <h1><?php echo e($listing_page_data->name); ?></h1>
    <nav>
        <ol class="breadcrumb justify-content-center">
            <li class="breadcrumb-item"><a href="<?php echo e(url('/')); ?>"><?php echo e(HOME); ?></a></li>
            <li class="breadcrumb-item active"><?php echo e($listing_page_data->name); ?></li>
        </ol>
    </nav>
</div>

<div class="page-content">
    <div class="container">
        <div class="row listing pt_0 pb_0">
            <div class="col-lg-4 col-md-6 col-sm-12">
                <form id="searchFormId">
                    <div class="listing-filter">
                        <div class="lf-heading">
                            <?php echo e(FILTERS); ?>

                        </div>
                        <div class="lf-widget">
                            <input type="text" id="text" name="text" class="form-control" placeholder="<?php echo e(FIND_ANYTHING); ?>" value="<?php echo e(request()->has('text') ? request()->get('text') : ''); ?>">
                        </div>
                        <div class="lf-widget">
                            <h2><?php echo e(TYPE); ?></h2>
                            <select name="listing_type" class="form-control" id="listing_type">
								<option value="" ><?php echo e(ALL); ?></option>
                                <?php if(request()->has('listing_type')): ?>
                                    <option <?php echo e(request()->get('listing_type') ==  'New Car' ? 'selected' : ''); ?>  value="New Car" ><?php echo e(NEW_CAR); ?></option>
								    <option <?php echo e(request()->get('listing_type') ==  'Used Car' ? 'selected' : ''); ?> value="Used Car" ><?php echo e(USED_CAR); ?></option>
                                <?php else: ?>
                                <option value="New Car" ><?php echo e(NEW_CAR); ?></option>
								<option value="Used Car" ><?php echo e(USED_CAR); ?></option>
                                <?php endif; ?>
							</select>
                        </div>
                        <?php
                            $sort_cat = [];
                            if(request()->has('brand')){
                                foreach(request()->get('brand') as $cat){
                                    array_push($sort_cat,(int)$cat);
                                }
                            }
                        ?>
                        <div class="lf-widget">
                            <h2><?php echo e(BRANDS); ?></h2>
                            <?php $ii=0; ?>
                            <?php $__currentLoopData = $listing_brands; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $index => $row): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <div class="form-check">
                                    <input <?php echo e(in_array($row->id ,$sort_cat) ? 'checked' : ''); ?> name="brand[]" class="form-check-input" type="checkbox" value="<?php echo e($row->id); ?>" id="cat<?php echo e($index); ?>">
                                    <label class="form-check-label" for="cat<?php echo e($index); ?>">
                                        <?php echo e($row->listing_brand_name); ?>

                                    </label>
                                </div>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </div>
                        <?php
                            $sort_aminity = [];
                            if(request()->has('amenity')){
                                foreach(request()->get('amenity') as $cat){
                                    array_push($sort_aminity,(int)$cat);
                                }
                            }
                        ?>
                        <div class="lf-widget">
                            <h2><?php echo e(AMENITIES); ?></h2>
                            <?php $__currentLoopData = $amenities; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $index => $row): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <div class="form-check">
                                    <input <?php echo e(in_array($row->id ,$sort_aminity) ? 'checked' : ''); ?> name="amenity[]" class="form-check-input" type="checkbox" value="<?php echo e($row->id); ?>" id="amn<?php echo e($index); ?>" >
                                    <label class="form-check-label" for="amn<?php echo e($index); ?>">
                                        <?php echo e($row->amenity_name); ?>

                                    </label>
                                </div>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </div>
                        <?php
                            $sort_loc = [];
                            if(request()->has('location')){
                                foreach(request()->get('location') as $cat){
                                    array_push($sort_loc,(int)$cat);
                                }
                            }
                        ?>
                        <div class="lf-widget">
                            <h2><?php echo e(LOCATIONS); ?></h2>
                            <?php $__currentLoopData = $listing_locations; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $index => $row): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <div class="form-check">
                                    <input <?php echo e(in_array($row->id ,$sort_loc) ? 'checked' : ''); ?> name="location[]" class="form-check-input" type="checkbox" value="<?php echo e($row->id); ?>" id="loc<?php echo e($index); ?>">
                                    <label class="form-check-label" for="loc<?php echo e($index); ?>">
                                        <?php echo e($row->listing_location_name); ?>

                                    </label>
                                </div>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </div>
                        <div class="form-group">
                            <input type="submit" class="form-control filter-button" value="<?php echo e(FILTER); ?>">
                        </div>
                    </div>
                </form>
            </div>

            <div class="col-lg-8 col-md-6 col-sm-12">
                <div class="right-area">
                    <div class="row d-none" id="loader-area">
                        <div class="col-12 text-center mt-5">
                            <div>
                                <img src="<?php echo e(asset('loader.gif')); ?>" alt="">
                            </div>
                        </div>
                    </div>
                    <div class="row" id="content-area">
                        <div class="col-12 text-center mt-5">
                            <div>
                                <img src="<?php echo e(asset('loader.gif')); ?>" alt="">
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<script>
    let loaderHtml = $("#loader-area").html();
    (function($) {
        "use strict";
        $(document).ready(function () {
            loadListingUsingAjax();
            $("#searchFormId").on('submit', function(e){
                e.preventDefault();
                submitSearchForm()
            })
            $("#listing_type").on('change', function(){
                submitSearchForm()
            })
            $(".form-check-input").on('click', function(){
                submitSearchForm()
            })
            $("#text").on('keyup', function(e){
                if(e.target.keyCode === '13'){
                    submitSearchForm()
                }
            })
        });
    })(jQuery);

    function loadListingUsingAjax(){
        submitSearchForm()
    }

    function submitSearchForm(){
        $('#content-area').html(loaderHtml);

        $.ajax({
            type: 'get',
            data: $('#searchFormId').serialize(),
            url: "<?php echo e(route('search-front_listing_result')); ?>",
            success: function (response) {
                $('#content-area').html(response);
            },
            error: function(err) {}
        });
    }

    function loadAjaxListing(url){
        $('#content-area').html(loaderHtml);
        $.ajax({
            type: 'get',
            url: url,
            success: function (response) {
                $('#content-area').html(response);
            },
            error: function(err) {}
        });
    }
</script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('front.app_front', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH D:\xampp\htdocs\phpscriptpoint\carpoint\carpoint\cms\resources\views/front/listing_result.blade.php ENDPATH**/ ?>