
<?php $__env->startSection('admin_content'); ?>
    <h1 class="h3 mb-3 text-gray-800"><?php echo e(ADD_POST); ?></h1>

    <form action="<?php echo e(route('admin_blog_store')); ?>" method="post" enctype="multipart/form-data">
        <?php echo csrf_field(); ?>
        <div class="card shadow mb-4">
            <div class="card-header py-3">
                <h6 class="m-0 mt-2 font-weight-bold text-primary"></h6>
                <div class="float-right d-inline">
                    <a href="<?php echo e(route('admin_blog_view')); ?>" class="btn btn-primary btn-sm"><i class="fa fa-plus"></i> <?php echo e(VIEW_ALL); ?></a>
                </div>
            </div>
            <div class="card-body">
                <div class="form-group">
                    <label for=""><?php echo e(TITLE); ?> *</label>
                    <input type="text" name="post_title" class="form-control" value="<?php echo e(old('post_title')); ?>" autofocus>
                </div>
                <div class="form-group">
                    <label for=""><?php echo e(SLUG); ?></label>
                    <input type="text" name="post_slug" class="form-control" value="<?php echo e(old('post_slug')); ?>">
                </div>
                <div class="form-group">
                    <label for=""><?php echo e(CONTENT); ?> *</label>
                    <textarea name="post_content" class="form-control editor" cols="30" rows="10"><?php echo e(old('post_content')); ?></textarea>
                </div>
                <div class="form-group">
                    <label for=""><?php echo e(SHORT_CONTENT); ?> *</label>
                    <textarea name="post_content_short" class="form-control h_100" cols="30" rows="10"><?php echo e(old('post_content_short')); ?></textarea>
                </div>
                <div class="form-group">
                    <label for=""><?php echo e(PHOTO); ?> *</label>
                    <div>
                        <input type="file" name="post_photo">
                    </div>
                </div>
                <div class="row">
                    <div class="col-md-4">
                        <div class="form-group">
                            <label for=""><?php echo e(SELECT_CATEGORY); ?> *</label>
                            <select name="category_id" class="form-control">
                                <?php $__currentLoopData = $category; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $row): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <option value="<?php echo e($row->id); ?>"><?php echo e($row->category_name); ?></option>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </select>
                        </div>
                    </div>
                </div>
                <div class="row">
                    <div class="col-md-4">
                        <div class="form-group">
                            <label for=""><?php echo e(QUESTION_SHOW_COMMENT); ?> *</label>
                            <select name="comment_show" class="form-control">
                                <option value="Yes"><?php echo e(YES); ?></option>
                                <option value="No"><?php echo e(NO); ?></option>
                            </select>
                        </div>
                    </div>
                </div>
            </div>
            <div class="card-header py-3">
                <h6 class="m-0 font-weight-bold text-primary"><?php echo e(SEO_INFORMATION); ?></h6>
            </div>
            <div class="card-body">
                <div class="form-group">
                    <label for=""><?php echo e(TITLE); ?></label>
                    <input type="text" name="seo_title" class="form-control" value="<?php echo e(old('seo_title')); ?>">
                </div>
                <div class="form-group">
                    <label for=""><?php echo e(META_DESCRIPTION); ?></label>
                    <textarea name="seo_meta_description" class="form-control h_100" cols="30" rows="10"><?php echo e(old('seo_meta_description')); ?></textarea>
                </div>
                <button type="submit" class="btn btn-success"><?php echo e(SUBMIT); ?></button>
            </div>
        </div>
    </form>

<?php $__env->stopSection(); ?>

<?php echo $__env->make('admin.app_admin', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/tbooking/globalegyptlimousine.com/resources/views/admin/blog_create.blade.php ENDPATH**/ ?>