

<?php $__env->startSection('content'); ?>

<div class="page-banner" style="background-image: url('<?php echo e(asset('uploads/page_banners/'.$contact_data->banner)); ?>')">
	<div class="page-banner-bg"></div>
    <h1><?php echo e($contact_data->name); ?></h1>
	<nav>
		<ol class="breadcrumb justify-content-center">
			<li class="breadcrumb-item"><a href="<?php echo e(url('/')); ?>"><?php echo e(HOME); ?></a></li>
			<li class="breadcrumb-item active"><?php echo e($contact_data->name); ?></li>
		</ol>
	</nav>
</div>

<div class="page-content pt_0">

<div class="contact-page-map">
	<?php echo $contact_data->contact_map; ?>

</div>


	<div class="container">
		<div class="row">
			<div class="col-lg-4 col-md-6">
				<div class="contact-item">
                    <div class="contact-icon">
                        <i class="fas fa-map-marker-alt"></i>
                    </div>
                    <div class="contact-text">
                        <h4><?php echo e(ADDRESS); ?></h4>
                        <p>
                            <?php echo clean(nl2br($contact_data->contact_address)); ?>

                        </p>
                    </div>
                </div>
			</div>
			<div class="col-lg-4 col-md-6">
				<div class="contact-item">
                    <div class="contact-icon">
                        <i class="fas fa-phone-volume"></i>
                    </div>
                    <div class="contact-text">
                        <h4><?php echo e(PHONE_NUMBER); ?></h4>
                        <p>
                            <?php echo clean(nl2br($contact_data->contact_phone)); ?>

                        </p>
                    </div>
                </div>
			</div>
			<div class="col-lg-4 col-md-6">
				<div class="contact-item">
                    <div class="contact-icon">
                        <i class="far fa-envelope"></i>
                    </div>
                    <div class="contact-text">
                        <h4><?php echo e(EMAIL_ADDRESS); ?></h4>
                        <p>
                            <?php echo clean(nl2br($contact_data->contact_email)); ?>

                        </p>
                    </div>
                </div>
			</div>
		</div>
		<div class="row contact-form">
			<div class="col-md-12">
				<h4 class="contact-form-title mt_50 mb_20"><?php echo e(CONTACT_FORM); ?></h4>
				<form action="<?php echo e(route('front_contact_form')); ?>" method="post">
					<?php echo csrf_field(); ?>
					<div class="row">
						<div class="col-lg-4 col-md-12">
							<div class="form-group">
								<label><?php echo e(NAME); ?> *</label>
								<input type="text" class="form-control" name="visitor_name">
							</div>
						</div>
						<div class="col-lg-4 col-md-12">
							<div class="form-group">
								<label><?php echo e(EMAIL_ADDRESS); ?> *</label>
								<input type="email" class="form-control" name="visitor_email">
							</div>
						</div>
						<div class="col-lg-4 col-md-12">
							<div class="form-group">
								<label><?php echo e(PHONE_NUMBER); ?></label>
								<input type="text" class="form-control" name="visitor_phone">
							</div>
						</div>
					</div>
					<div class="form-group">
						<label><?php echo e(MESSAGE); ?> *</label>
						<textarea name="visitor_message" class="form-control h-200" cols="30" rows="10"></textarea>
					</div>
					<?php if($g_setting->google_recaptcha_status == 'Show'): ?>
                    <div class="form-group">
                        <div class="g-recaptcha" data-sitekey="<?php echo e($g_setting->google_recaptcha_site_key); ?>"></div>
                    </div>
                    <?php endif; ?>
					<button type="submit" class="btn btn-primary mt_10"><?php echo e(SEND_MESSAGE); ?></button>
				</form>
			</div>
		</div>
	</div>
</div>

<?php $__env->stopSection(); ?>

<?php echo $__env->make('front.app_front', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH D:\xampp\htdocs\phpscriptpoint\carpoint\carpoint\cms\resources\views/front/contact.blade.php ENDPATH**/ ?>