@extends('admin.app_admin')
@section('admin_content')
    <h1 class="h3 mb-3 text-gray-800">{{ EDIT_DYNAMIC_PAGE }}</h1>

    <form action="{{ route('admin_dynamic_page_update',$dynamic_page->id) }}" method="post" enctype="multipart/form-data">
        @csrf

        <input type="hidden" name="current_banner" value="{{ $dynamic_page->dynamic_page_banner }}">

        <div class="card shadow mb-4">
            <div class="card-header py-3">
                <h6 class="m-0 mt-2 font-weight-bold text-primary"></h6>
                <div class="float-right d-inline">
                    <a href="{{ route('admin_dynamic_page_view') }}" class="btn btn-primary btn-sm"><i class="fa fa-plus"></i> {{ VIEW_ALL }}</a>
                </div>
            </div>
            <div class="card-body">
                <div class="form-group">
                    <label for="">{{ NAME }} *</label>
                    <input type="text" name="dynamic_page_name" class="form-control" value="{{ $dynamic_page->dynamic_page_name }}" autofocus>
                </div>
                <div class="form-group">
                    <label for="">{{ SLUG }}</label>
                    <input type="text" name="dynamic_page_slug" class="form-control" value="{{ $dynamic_page->dynamic_page_slug }}">
                </div>
                <div class="form-group">
                    <label for="">{{ CONTENT }}</label>
                    <textarea name="dynamic_page_content" class="form-control editor" cols="30" rows="10">{{ $dynamic_page->dynamic_page_content }}</textarea>
                </div>
                <div class="form-group">
                    <label for="">{{ EXISTING_BANNER }}</label>
                    <div>
                        <img src="{{ asset('uploads/page_banners/'.$dynamic_page->dynamic_page_banner) }}" alt="" class="w_300">
                    </div>
                </div>
                <div class="form-group">
                    <label for="">{{ CHANGE_BANNER }}</label>
                    <div>
                        <input type="file" name="dynamic_page_banner">
                    </div>
                </div>
            </div>
            <div class="card-header py-3">
                <h6 class="m-0 font-weight-bold text-primary">{{ SEO_INFORMATION }}</h6>
            </div>
            <div class="card-body">
                <div class="form-group">
                    <label for="">{{ TITLE }}</label>
                    <input type="text" name="seo_title" class="form-control" value="{{ $dynamic_page->seo_title }}">
                </div>
                <div class="form-group">
                    <label for="">{{ META_DESCRIPTION }}</label>
                    <textarea name="seo_meta_description" class="form-control h_100" cols="30" rows="10">{{ $dynamic_page->seo_meta_description }}</textarea>
                </div>
                <button type="submit" class="btn btn-success">{{ UPDATE }}</button>
            </div>
        </div>
    </form>

@endsection
